/**************************************************************************/
/*                                                                        */
/* Header file:        INTS_INI.H                                         */
/*                                                                        */
/* Function:           Interactive Service Interface                      */
/*                     -- Service definition file                         */
/*                                                                        */
/* Author:             W. Reichert, D.3228                                */
/*                                                                        */
/* Date created:       1991-02-20                                         */
/*                                                                        */
/* Classification:     IBM Internal Use Only                              */
/*                                                                        */
/**************************************************************************/
/* This part is included only by the initialization module INTS_INI.C.    */
/* Here all supported API functions (their name and their calling routine)*/
/* are defined.  When adding or changing these definitions INTS_INI.C     */
/* must be recompiled and linked.                                         */
/**************************************************************************/

/**************************************************************************/
/* Function declaration for all services                                  */
/**************************************************************************/

/* Special INTSRV functions (don't change them) */

USHORT ISIClose(VOID);
USHORT ISICondSect(VOID);
USHORT ISICopyVar(VOID);
USHORT ISIEnd(VOID);
USHORT ISIMonitor(VOID);
USHORT ISIOutput(VOID);
USHORT ISIPlay(VOID);
USHORT ISIRecord(VOID);
USHORT ISIReturn(VOID);
USHORT ISISetVar(VOID);
USHORT ISISetVarSize(VOID);
USHORT ISIShowFunctions(VOID);
USHORT ISIShowVar(VOID);
USHORT ISITest(VOID);
USHORT ISIVersion(VOID);
USHORT ISIDebug(VOID);
USHORT ISIINTSRV(VOID);

/* Application-specific functions */

/* DOS calls et al (samples) */

USHORT ISIDosBeep(VOID);
USHORT ISIDosChDir(VOID);
USHORT ISIDosExecPgm(VOID);
USHORT ISIDosFreeModule(VOID);
USHORT ISIDosLoadModule(VOID);
USHORT ISIDosSelectDisk(VOID);
USHORT ISIDosSleep(VOID);

#ifndef __32BIT__
USHORT ISIDosAllocSeg(VOID);
USHORT ISIDosFreeSeg(VOID);
USHORT ISIDosGetInfoSeg(VOID);
USHORT ISIDosGetModHandle(VOID);
USHORT ISIDosGetModName(VOID);
USHORT ISIDosGetPID(VOID);
USHORT ISIDosReallocSeg(VOID);
#endif

USHORT ISIsystem(VOID);
USHORT ISImalloc(VOID);
USHORT ISIfree(VOID);

USHORT ISIShowMem(VOID);
USHORT ISISetMem(VOID);

USHORT ISISampleFunc1(VOID);
USHORT ISISampleFunc2(VOID);
USHORT ISISampleFunc3(VOID);

/* Here you may add your own declarations ... */
 
/* ... */

/**************************************************************************/
/* Structure: Name all functions and their address (entry point)          */
/* (This part is included by INTS_INI.C only)                             */
/**************************************************************************/
 
#ifdef INCL_FUNC

ISI_FUNC ISI_astuFunctions[] =
{
    /* Special INTSRV functions */
    "$Debug",                          ISIDebug,
    "INTSRV",                          ISIINTSRV,
    "Close",                           ISIClose,
    "CondSect",                        ISICondSect,
    "CopyVar",                         ISICopyVar,
    "End",                             ISIEnd,
    "Monitor",                         ISIMonitor,
    "Output",                          ISIOutput,
    "Play",                            ISIPlay,
    "Record",                          ISIRecord,
    "Return",                          ISIReturn,
    "SetVar",                          ISISetVar,
    "SetVarSize",                      ISISetVarSize,
    "ShowFunctions",                   ISIShowFunctions,
    "ShowVar",                         ISIShowVar,
    "Test",                            ISITest,
    "Version",                         ISIVersion,


    /* Dos calls et al (samples) */
#ifndef __32BIT__
    "DosAllocSeg",                     ISIDosAllocSeg,
    "DosFreeSeg",                      ISIDosFreeSeg,
    "DosGetInfoSeg",                   ISIDosGetInfoSeg,
    "DosGetModHandle",                 ISIDosGetModHandle,
    "DosGetModName",                   ISIDosGetModName,
    "DosGetPID",                       ISIDosGetPID,
    "DosReallocSeg",                   ISIDosReallocSeg,
#endif
 
    "DosFreeModule",                   ISIDosFreeModule,
    "DosBeep",                         ISIDosBeep,
    "DosChDir",                        ISIDosChDir,
    "DosExecPgm",                      ISIDosExecPgm,
    "DosLoadModule",                   ISIDosLoadModule,
    "DosSelectDisk",                   ISIDosSelectDisk,
    "DosSleep",                        ISIDosSleep,
 
    "system",                          ISIsystem,
    "malloc",                          ISImalloc,
    "free",                            ISIfree,
    "ShowMem",                         ISIShowMem,
    "SetMem",                          ISISetMem,

    /* Here you may add your own associations ... */

    "SampleFunc1",                     ISISampleFunc1,
    "SampleFunc2",                     ISISampleFunc2,
    "SampleFunc3",                     ISISampleFunc3,

    /* End-of-structure indicator */
    NULL,                              NULL
};
 
#endif /* INCL_FUNC */
